Button = copy_table(Bitmap)

--[[
Button.sample_definition = {
        type = "Button",
        bitmap = "gfx/buttons/buttstd_exit",
        bitmap_hi = "gfx/buttons/buttstd_exit_hi",
        x=400, y=400, z=10,
        mouse_down = "mouse_down_options",
        --w = 128, h = 64,
        --cx = 64, cy = 32,
        --area = { x0 = 0, y0 = 0, x1 = 127, y1 = 63 }
}
--]]


function Button:init(def, view)
    Bitmap.init(self, def, view)

    -- set up highlight
    self.bitmap_hi = gfx_load_bitmap(def.bitmap_hi)
    self.sprite_hi = def.sprite_hi or def.sprite or "main"

    self.color_hi = def.color_hi
    self.color_blocked = def.color_blocked
    
    self.click_sound = def.click_sound or "button_click"
    self.highlight_sound = def.highlight_sound or "button_highlight"


    if def.bitmap_blocked then
        self.bitmap_blocked = gfx_load_bitmap(def.bitmap_blocked)
        self.sprite_blocked = def.sprite_blocked or def.sprite or "main"
        self.blocked_with_overlay = def.blocked_with_overlay
    end

    self.highlight_on = true
end


function Button:set_blocked(block)
    if block and not self.blocked then
        self.blocked = true
        self.highlight_on = false
        self.blocked_area = self.area
        self.area = nil
    elseif not block and self.blocked then
        self.blocked = false
        self.highlight_on = true
        self.area = self.blocked_area
        self.blocked_area = nil
    end
end


function Button:destroy()
    gfx_release_bitmap(self.bitmap_hi)
    Bitmap.destroy(self)
end


function Button:render()
    if self.blocked then
        if self.bitmap and (self.blocked_with_overlay or not self.bitmap_blocked) then
            gfx_render_sprite(self.bitmap, self.sprite, self.x, self.y, 1, self.angle, self.scale_x, self.scale_y, self.color)
        end
        if self.bitmap_blocked then
            gfx_render_sprite(self.bitmap_blocked, self.sprite_blocked, self.x, self.y, 1, self.angle, self.scale_x, self.scale_y, self.color_blocked)
        end
    else
        if self.bitmap then
            gfx_render_sprite(self.bitmap, self.sprite, self.x, self.y, 1, self.angle, self.scale_x, self.scale_y, self.color)
        end
        if self.hi_alpha > 0 then
            gfx_render_sprite(self.bitmap_hi, self.sprite_hi, self.x, self.y, self.hi_alpha, self.angle, self.scale_x, self.scale_y, self.color_hi)
        end
    end
end


function Button:mouse_in()
    snd_play_sound(self.highlight_sound)
end


function Button:mouse_left_click()
    snd_play_sound(self.click_sound)
end

